/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package chatapp;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 *
 * @author francois
 */
public class Utilmd5 {

    /**
    * Constructeur privé : interdit l'instanciation de cette classe.
    */
    private Utilmd5() {}

    /**
    * Code la chaine donnée sous forme de chaîne hexadécimale du digest md5.
    *
    * @param str chaine à coder.
    * @return Données codées sous forme de chaîne hexadécimale du digest md5 de str
    */
	public static String md5(String str) throws NoSuchAlgorithmException {
          byte[] md5 = MessageDigest.getInstance("MD5").digest(str.getBytes()) ;
          return hex_encode(md5);
	}

    /**
    * Code les données spécifiées sous forme de chaîne composée de caractères hexadécimaux.
    *
    * @param data Données à coder.
    * @return Données codées sous forme de chaîne hexadécimale.
    */

	public static String hex_encode(byte[] data) {
          StringBuilder builder=new StringBuilder();

          for(byte dataByte: data)
          {
            // Un octet est représenté par 2 caractères hexadécimaux
            builder.append(Integer.toHexString((dataByte & 0xF0)>>4));
            builder.append(Integer.toHexString(dataByte & 0x0F));
          }
          return builder.toString();
	}
}